<?php
require_once __DIR__ . '/../includes/db.php';

function find_user_by_username($username){
    global $pdo;
    $stmt = $pdo->prepare('SELECT * FROM users WHERE username = ?');
    $stmt->execute([$username]);
    return $stmt->fetch();
}

function register_user($username, $password, $name, $email){
    global $pdo;
    $hash = password_hash($password, PASSWORD_BCRYPT);
    $stmt = $pdo->prepare('INSERT INTO users (username,password,name,email) VALUES (?,?,?,?)');
    return $stmt->execute([$username,$hash,$name,$email]);
}

function require_login(){
    if(session_status() === PHP_SESSION_NONE) session_start();
    if(!isset($_SESSION['user'])){
        header('Location: login.php'); exit;
    }
}

function is_admin(){
    if(session_status() === PHP_SESSION_NONE) session_start();
    return (isset($_SESSION['user']) && $_SESSION['user']['role'] === 'admin');
}
