<?php
require_once('../../includes/db.php');

// Hapus data jika ada request
if (isset($_GET['delete'])) {
    $deleteId = (int) $_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM requests WHERE id = :id");
    $stmt->execute([':id' => $deleteId]);
    header("Location: index.php"); // refresh biar data terupdate
    exit;
}

// Ambil query pencarian
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

// Tentukan limit default (jumlah data per halaman)
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 10;
if (!in_array($limit, [10, 20, 50])) {
    $limit = 10;
}

// Tentukan halaman aktif
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
if ($page < 1) $page = 1;

// Hitung offset
$offset = ($page - 1) * $limit;

// Hitung total data dengan pencarian
$total_stmt = $pdo->prepare("SELECT COUNT(*) AS total 
    FROM requests r 
    JOIN users u ON r.user_id = u.id
    WHERE r.title LIKE :search OR u.name LIKE :search");
$total_stmt->execute([':search' => "%$search%"]);
$total_rows = $total_stmt->fetch();
$total_data = $total_rows['total'];
$total_pages = ceil($total_data / $limit);

// Ambil data requests join dengan users + pencarian
$stmt = $pdo->prepare("SELECT r.id, r.title, u.name AS pengaju, r.submitted_at, r.status
                       FROM requests r
                       JOIN users u ON r.user_id = u.id
                       WHERE r.title LIKE :search OR u.name LIKE :search
                       ORDER BY r.submitted_at DESC
                       LIMIT :limit OFFSET :offset");
$stmt->bindValue(':search', "%$search%", PDO::PARAM_STR);
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$requests = $stmt->fetchAll();
?>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Semua Permintaan</h3>
        <div>
            <form method="get" class="d-flex align-items-center">

                <!-- Pencarian -->
                <input type="text" name="search" class="form-control form-control-sm me-2" 
                       placeholder="Cari judul / pengaju" value="<?= htmlspecialchars($search) ?>">
					   <button type="submit" class="btn btn-sm btn-secondary form-control-sm me-2">Cari</button>
					   
                <!-- Jumlah data -->
                <select name="limit" class="form-select form-select-sm me-2" onchange="this.form.submit()">
                    <option value="10" <?= $limit==10 ? 'selected' : '' ?>>10</option>
                    <option value="20" <?= $limit==20 ? 'selected' : '' ?>>20</option>
                    <option value="50" <?= $limit==50 ? 'selected' : '' ?>>50</option>
					
                </select>
                
				<a href="logout.php" class="btn btn-danger btn-sm">Logout</a>
            </form>
        </div>
    </div>

    <table class="table table-bordered table-striped">
        <thead class="table-dark">
            <tr>
                <th>No</th>
                <th>Judul</th>
                <th>Pengaju</th>
                <th>Tanggal</th>
                <th>Status</th>
                <th>Aksi</th>
            </tr>
        </thead>
        <tbody>
            <?php if (count($requests) > 0): ?>
                <?php foreach($requests as $row): ?>
                <tr>
                    <td><?= $row['id'] ?></td>
                    <td><?= htmlspecialchars($row['title']) ?></td>
                    <td><?= htmlspecialchars($row['pengaju']) ?></td>
                    <td><?= $row['submitted_at'] ?></td>
                    <td>
                        <?php if ($row['status'] == 'Pending'): ?>
                            <span class="badge bg-warning text-dark"><?= $row['status'] ?></span>
                        <?php elseif ($row['status'] == 'Completed'): ?>
                            <span class="badge bg-success"><?= $row['status'] ?></span>
                        <?php elseif ($row['status'] == 'Rejected'): ?>
                            <span class="badge bg-danger"><?= $row['status'] ?></span>
                        <?php else: ?>
                            <span class="badge bg-info text-dark"><?= $row['status'] ?></span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="view_request.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">Proses</a>
                        <a href="index.php?delete=<?= $row['id'] ?>" 
                           class="btn btn-sm btn-danger"
                           onclick="return confirm('Yakin ingin menghapus data ini?');">
                           Hapus
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" class="text-center">Tidak ada data ditemukan</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
	
    <!-- Pagination -->
    <nav>
        <ul class="pagination">
            <?php if ($page > 1): ?>
                <li class="page-item"><a class="btn btn-dark" href="?page=<?= $page-1 ?>&limit=<?= $limit ?>&search=<?= urlencode($search) ?>">« Prev</a></li>
            <?php endif; ?>

            <?php for($i=1; $i <= $total_pages; $i++): ?>
                <li class="page-item <?= $i==$page ? 'active' : '' ?>">
                    <a class="btn btn-dark" href="?page=<?= $i ?>&limit=<?= $limit ?>&search=<?= urlencode($search) ?>"><?= $i ?></a>
                </li>
            <?php endfor; ?>

            <?php if ($page < $total_pages): ?>
                <li class="page-item"><a class="btn btn-dark" href="?page=<?= $page+1 ?>&limit=<?= $limit ?>&search=<?= urlencode($search) ?>">Next »</a></li>
            <?php endif; ?>
        </ul>
    </nav>
</div>
