<?php
require_once __DIR__ . '/../../includes/functions.php';
require_login();
if(!is_admin()) { header('Location: ../login.php'); exit; }
global $pdo;
$id = intval($_GET['id'] ?? 0);
$stmt = $pdo->prepare('SELECT r.*, u.name as requester FROM requests r JOIN users u ON u.id=r.user_id WHERE r.id = ?');
$stmt->execute([$id]);
$r = $stmt->fetch();
if(!$r){ die('Request tidak ditemukan'); }

if($_SERVER['REQUEST_METHOD']=='POST'){
  $status = $_POST['status'] ?? 'Pending';
  $score = $_POST['similarity_score'] ?? null;
  $notes = $_POST['admin_notes'] ?? null;
  if(isset($_FILES['report']) && $_FILES['report']['error']===0){
    $ext = pathinfo($_FILES['report']['name'], PATHINFO_EXTENSION);
    $rn = 'report_'.time().'_'.bin2hex(random_bytes(4)).'.'.$ext;
    if(!is_dir(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0755, true);
    move_uploaded_file($_FILES['report']['tmp_name'], UPLOAD_DIR . $rn);
    $report_path = 'uploads/'.$rn;
    $stmt = $pdo->prepare('UPDATE requests SET status=?, similarity_score=?, report_path=?, admin_notes=? WHERE id=?');
    $stmt->execute([$status, $score, $report_path, $notes, $id]);
  } else {
    $stmt = $pdo->prepare('UPDATE requests SET status=?, similarity_score=?, admin_notes=? WHERE id=?');
    $stmt->execute([$status, $score, $notes, $id]);
  }
  header('Location: index.php?updated=1'); exit;
}
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Proses Permintaan Turnitin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body { background: #f5f7fb; }
    .page-title { font-weight: 700; letter-spacing: .2px; }
    .card { border: 0; border-radius: 1rem; box-shadow: 0 8px 24px rgba(0,0,0,.06); }
    .badge-status { font-size: .8rem; }
    .kv { font-weight: 600; width: 160px; color: #6c757d; }
    .nav-light { background: #ffffff; box-shadow: 0 4px 16px rgba(0,0,0,.04); }
  </style>
</head>
<body>
<nav class="navbar nav-light navbar-expand-lg mb-4">
  <div class="container">
    <a class="navbar-brand fw-bold" href="index.php"><i class="bi bi-file-earmark-text"></i> Turnitin Admin</a>
    <div class="d-flex gap-2">
      <a href="index.php" class="btn btn-outline-secondary"><i class="bi bi-arrow-left"></i> Kembali</a>
    </div>
  </div>
</nav>

<div class="container pb-5">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <h1 class="page-title h3 mb-0">Proses Permintaan #<?=intval($r['id'])?></h1>
    <span class="badge rounded-pill text-bg-<?= ($r['status']=='Completed'?'success':($r['status']=='In Progress'?'primary':($r['status']=='Rejected'?'danger':'secondary'))) ?> badge-status">
      <i class="bi bi-circle-fill me-1"></i><?=htmlspecialchars($r['status'])?>
    </span>
  </div>

  <div class="row g-4">
    <div class="col-lg-6">
      <div class="card">
        <div class="card-header bg-white py-3">
          <div class="d-flex align-items-center gap-2">
            <i class="bi bi-info-circle"></i><span class="fw-semibold">Detail Permintaan</span>
          </div>
        </div>
        <div class="card-body">
          <div class="d-flex py-2 border-bottom">
            <div class="kv">Judul</div>
            <div class="flex-grow-1"><?=htmlspecialchars($r['title'])?></div>
          </div>
          <div class="d-flex py-2 border-bottom">
            <div class="kv">Pengaju</div>
            <div class="flex-grow-1"><?=htmlspecialchars($r['requester'])?></div>
          </div>
          <div class="d-flex py-2 border-bottom">
            <div class="kv">Berkas</div>
            <div class="flex-grow-1">
              <a class="link-primary" href="../<?=htmlspecialchars($r['file_path'])?>" target="_blank">
                <i class="bi bi-download"></i> Unduh File
              </a>
            </div>
          </div>
          <div class="d-flex py-2">
            <div class="kv">Nilai Similarity</div>
            <div class="flex-grow-1">
              <?= $r['similarity_score']!==null && $r['similarity_score']!=='' ? htmlspecialchars($r['similarity_score']).'%' : '<span class="text-muted">Belum diisi</span>' ?>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-lg-6">
      <div class="card">
        <div class="card-header bg-white py-3">
          <div class="d-flex align-items-center gap-2">
            <i class="bi bi-gear"></i><span class="fw-semibold">Update Status & Hasil</span>
          </div>
        </div>
        <div class="card-body">
          <form method="post" enctype="multipart/form-data" class="needs-validation" novalidate>
            <div class="mb-3">
              <label class="form-label">Status</label>
              <select name="status" class="form-select" required>
                <option value="Pending" <?= $r['status']=='Pending'?'selected':''; ?>>Pending</option>
                <option value="In Progress" <?= $r['status']=='In Progress'?'selected':''; ?>>In Progress</option>
                <option value="Completed" <?= $r['status']=='Completed'?'selected':''; ?>>Completed</option>
                <option value="Rejected" <?= $r['status']=='Rejected'?'selected':''; ?>>Rejected</option>
              </select>
              <div class="invalid-feedback">Pilih status.</div>
            </div>

            <div class="mb-3">
              <label class="form-label">Similarity Score (%)</label>
              <input type="number" step="01" min="0" max="100" name="similarity_score" class="form-control" placeholder="Contoh: 18.5" value="<?=htmlspecialchars($r['similarity_score'])?>">
              <div class="form-text">Opsional. Isi setelah pemeriksaan selesai.</div>
            </div>

            <div class="mb-3">
              <label class="form-label">Upload Laporan (PDF)</label>
              <input type="file" name="report" class="form-control" accept="application/pdf">
              <div class="form-text">Unggah file laporan hasil pemeriksaan (format PDF).</div>
            </div>

            <div class="mb-3">
              <label class="form-label">Catatan Admin</label>
              <textarea name="admin_notes" rows="4" class="form-control" placeholder="Catatan untuk pemohon..."><?=htmlspecialchars($r['admin_notes'])?></textarea>
            </div>

            <div class="d-flex gap-2">
              <button class="btn btn-primary"><i class="bi bi-save"></i> Simpan</button>
              <a href="index.php" class="btn btn-danger">Batal</a>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Simple client-side validation feedback
(() => {
  const forms = document.querySelectorAll('.needs-validation');
  Array.from(forms).forEach(form => {
    form.addEventListener('submit', event => {
      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      }
      form.classList.add('was-validated');
    }, false);
  });
})();
</script>
</body>
</html>
