CREATE DATABASE IF NOT EXISTS `turnitin_db` DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE `turnitin_db`;

CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  username VARCHAR(100) NOT NULL UNIQUE,
  password VARCHAR(255) NOT NULL,
  name VARCHAR(150) NOT NULL,
  email VARCHAR(150) DEFAULT NULL,
  role ENUM('student','admin') NOT NULL DEFAULT 'student',
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

CREATE TABLE requests (
  id INT AUTO_INCREMENT PRIMARY KEY,
  user_id INT NOT NULL,
  title VARCHAR(255) NOT NULL,
  course VARCHAR(150) DEFAULT NULL,
  supervisor VARCHAR(150) DEFAULT NULL,
  description TEXT,
  file_path VARCHAR(255) NOT NULL,
  submitted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  status ENUM('Pending','In Progress','Completed','Rejected') DEFAULT 'Pending',
  similarity_score VARCHAR(50) DEFAULT NULL,
  report_path VARCHAR(255) DEFAULT NULL,
  admin_notes TEXT DEFAULT NULL,
  FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB;

-- contoh admin awal
INSERT INTO users (username, password, name, email, role) VALUES (
  'admin',
  '$2y$10$e0NRH7YkE1bGqz6m.jz0Guq8sQ7QjZK04Qp5d8qJt9p0b9q7K8r6a',
  'Administrator', 'admin@example.com', 'admin'
);
